model Ex3_7

extends Modelica.Math;

// Variables
Real HR(unit="kJ")                             "Heat required per kg of aluminium";
Real HS(unit="kJ/kg")                          "Heat to be supplied";
Real RM(unit="kg/h")                           "Rate at which aluminium can be melted";
Real M(unit="tonnes")                          "Mass of aluminium that can be held in the furnance";


// Parameters
 parameter Real SH(unit="kJ/kg*K")=0.9           "Specific heat of alluminium in solid state";
 parameter Real L(unit="kJ/kg")=390              "Latent heat";
 parameter Real aw(unit="")=27                   "Atomic weight";
 parameter Real D(unit="kg/m^3")=2400            "Density in molten state";
 parameter Real Tf(unit="K")=973                 "Final temperature";
 parameter Real Tm(unit="K")=933                 "Melting point of aluminium";
 parameter Real Ti(unit="K")=288                 "Initial temperature";
 parameter Real V(unit="m^3")=2.18               "Volume";
 

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

HR =SH*(Tm-Ti)+L+(29.93/27)*(Tf-Tm); 	     //Heat required per kg of aluminium
HS =HR/0.7 ; 			                     //Heat to be supplied
RM = 217*1000*3600/HS ; 		             //Rate at which aluminium can be melted
M = V*D/1000;                                //Mass of aluminium that can be held in the furnance


end Ex3_7;
