model Ex3_8

extends Modelica.Math;

// Variables
Real N(unit="")                            "Number of droplets";
Real Af(unit="m^2")                        "Total surface area of all droplets";
Real S_L(unit="m^2/m")                     "S/L";
Real W(unit="J")                           "Work done during atomization";


// Parameters
 parameter Real dd(unit="m")=60e-06           "Diameter of droplets";
 parameter Real mw(unit="kg")=1               "Mass of water";
 parameter Real st(unit="N/m")=0.07           "Surfacte tension of water in contact with air";
 parameter Real rho(unit="kg/m^3")=1000       "Density of water";
 parameter Real dp(unit="m")=15e-03           "Diameter of pipe";
 

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

N = (mw*6)/(pi*dd^3*rho);                          //Number of droplets
Af = pi*dd^2*N;                                   //Total surface area of all droplets
S_L = 4/(dp*rho);                                 //Ratio of surface area and length=S/L
W = st*(100-S_L);                                 //Work done during atomization


end Ex3_8;
