model Ex7_12

extends Modelica.Math;
// Variables

Real delta_S1_2(unit="kJ/kg*K")                       "Change in entropy";
Real delta_S1_3(unit="kJ/kg*K")                       "Change in entropy";
Real delta_S_gen(unit="kW/K")                         "Entropy generation";

// Parameters
 parameter Real P1(unit="bar")=4                 "Pressure at point 1"; 
 parameter Real P2(unit="bar")=1                 "Pressure at point 2"; 
 parameter Real P3(unit="bar")=1                 "Pressure at point 3";
 parameter Real T1(unit="K")=300                 "Temperature at point 1";   
 parameter Real T2(unit="K")=330                 "Temperature at point 2";
 parameter Real T3(unit="K")=270                 "Temperature at point 3";
 parameter Real Cp(unit="kJ/kg*K")=1.005         "Specific heat at constant pressure"; 
 parameter Real R(unit="kJ/kg*K")=0.287          "Gas constant"; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 

delta_S1_2=(Cp*log(T2/T1))-(R*log(P2/P1));
delta_S1_3=(Cp*log(T3/T1))-(R*log(P3/P1));
delta_S_gen=delta_S1_2+delta_S1_3;

end Ex7_12;
