package Ex8_12

model Ex8_12_a

// Variables

Real n1(unit="%")                       "First law efficiency";
Real n2(unit="%")                       "Second law efficiency";

// Parameters
 
 
 parameter Real Qr(unit="kW")=500           "Rate of heat release at Tr"; 
 parameter Real Qa(unit="kW")=480           "Rate of heat absorption at Ta"; 
 parameter Real Tr(unit="K")=2000           "Heat release temperature" ; 
 parameter Real Ta(unit="K")=1000           "Heat absorption temperature" ;
 parameter Real T0(unit="K")=300            "Atmospheric temperature" ;
 
 // Equations

equation
// Metallurgical furnance
n1=(Qa/Qr)*100;
n2=n1*((1-(T0/Ta))/(1-(T0/Tr)));

end Ex8_12_a;
//===============================================================================================

model Ex8_12_b

// Variables

Real n1(unit="%")                       "First law efficiency";
Real n2(unit="%")                       "Second law efficiency";

// Parameters
 
 
 parameter Real Qr(unit="kW")=500           "Rate of heat release at Tr"; 
 parameter Real Qa(unit="kW")=450           "Rate of heat absorption at Ta"; 
 parameter Real Tr(unit="K")=2000           "Heat release temperature" ; 
 parameter Real Ta(unit="K")=500            "Heat absorption temperature" ;
 parameter Real T0(unit="K")=300            "Atmospheric temperature" ;
 
 // Equations

equation
// Steam generation
n1=(Qa/Qr)*100;
n2=n1*((1-(T0/Ta))/(1-(T0/Tr)));

end Ex8_12_b;
//================================================================================================


model Ex8_12_c

// Variables

Real n1(unit="%")                       "First law efficiency";
Real n2(unit="%")                       "Second law efficiency";

// Parameters
 
 
 parameter Real Qr(unit="kW")=500          "Rate of heat release at Tr"; 
 parameter Real Qa(unit="kW")=300          "Rate of heat absorption at Ta"; 
 parameter Real Tr(unit="K")=2000          "Heat release temperature" ; 
 parameter Real Ta(unit="K")=320           "Heat absorption temperature" ;
 parameter Real T0(unit="K")=300           "Atmospheric temperature" ;
 
 // Equations

equation
// Chemical process
n1=(Qa/Qr)*100;
n2=n1*((1-(T0/Ta))/(1-(T0/Tr)));

end Ex8_12_c;
//==============================================================================================


model Ex8_12_d

// Variables

Real n1(unit="%")                         "First law efficiency";
Real n2_a(unit="%")                       "Second law efficiency";
Real n2_b(unit="%")                       "Second law efficiency";
Real n2_c(unit="%")                       "Second law efficiency";

// Parameters
 
 
 parameter Real Qr(unit="kW")=500           "Rate of heat release at Tr"; 
 parameter Real Qa(unit="kW")=450           "Rate of heat absorption at Ta"; 
 parameter Real Tr(unit="K")=2000           "Heat release temperature" ; 
 parameter Real Ta_a(unit="K")=1000         "Heat absorption temperature" ;
 parameter Real Ta_b(unit="K")=500          "Heat absorption temperature" ;
 parameter Real Ta_c(unit="K")=320          "Heat absorption temperature" ;
 parameter Real T0(unit="K")=300            "Atmospheric temperature" ;
 
 // Equations

equation
// Chemical process
n1=(Qa/Qr)*100;
n2_a=n1*((1-(T0/Ta_a))/(1-(T0/Tr)));
n2_b=n1*((1-(T0/Ta_b))/(1-(T0/Tr)));
n2_c=n1*((1-(T0/Ta_c))/(1-(T0/Tr)));

end Ex8_12_d;



end Ex8_12;
