model Ex8_18

extends Modelica.Math;
// Variables


Real Q(unit="kJ/kg")                         "Heat transfer";
Real I(unit="kJ/kg")                         "Irreversibility";
Real E1(unit="kJ/kg")                        "Exergy utilized";
Real E2(unit="kJ/kg")                        "Exergy transferred";
Real n2(unit="%")                            "Second law efficiency";



// Parameters
 
 parameter Real W(unit="kJ/kg")=540                "Turbine work develop"; 
 parameter Real Tb(unit="K")=500                   "Surface temperature" ;
 parameter Real T0(unit="K")=298                   "Surrounding temperature of air" ;
 parameter Real h1(unit="kJ/kg")=3230.9            "Initial enthalpy" ; 
 parameter Real h2(unit="kJ/kg")=2676.1            "Final enthalpy" ; 
 parameter Real s1(unit="kJ/kg*K")=6.9212          "Initial entropy" ; 
 parameter Real s2(unit="kJ/kg*K")=7.3549          "Final entropy" ; 
 parameter Real V1(unit="m/s")=160                 "Initial velocity" ; 
 parameter Real V2(unit="m/s")=100                 "Final velocity" ; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

Q=(h1-h2)+((V1^2-V2^2)*1e-03/2)-W;
I=(h1-h2)-T0*(s1-s2)+((V1^2-V2^2)*1e-03/2)-W-Q*(1-T0/Tb);
//Exergy balance
//Exergy transferred=Exergy utilized
E1=W+Q*(1-T0/Tb)+I;
E2=(h1-h2)-T0*(s1-s2)+((V1^2-V2^2)*1e-03/2);
n2=W*100/E1;


end Ex8_18;
