package Ex8_20
  model Ex8_20_a
    extends Modelica.Math;
    // Variables
    Real T2(unit = "K")                          "Final temperature";
    // Parameters
    parameter Real p2(unit = "bar") = 3.5        "Initial pressure";
    parameter Real p1(unit = "bar") = 1          "Final pressure";
    parameter Real T1(unit = "K") = 303          "Initial temperature";
    parameter Real n(unit = "") = 1.4            "Polytropic index";
    final constant Real e = Modelica.Math.exp(1.0);
    // Equations
  equation
    T2 = T1 * (p2 / p1) ^ ((n - 1) / n);
  end Ex8_20_a;

  //==============================================================================================
model Ex8_20_b
    extends Modelica.Math;
    
    // Variables
    
    Real n(unit = "")                        "Polytropic index";
    
    // Parameters
    parameter Real p2(unit = "bar") = 3.5          "Final pressure";
    parameter Real p1(unit = "bar") = 1            "Initial pressure";
    parameter Real T1(unit = "K") = 303            "Initial temperature";
    parameter Real T2(unit = "K") = 414            "Final temperature";
    
    final constant Real e = Modelica.Math.exp(1.0);
    
    // Equations
    
  equation
  (T2/T1)=(p2/p1)^((n-1)/n);
    
  end Ex8_20_b;


 //===============================================================================================
  model Ex8_20_c
    extends Modelica.Math;
    // Variables
    Real Wa(unit = "kJ/kg")                        "Actual work of compression";
    Real Wt(unit = "kJ/kg")                        "Isothermal work";
    Real nt(unit = "%")                        "Isothermal efficiency";
    // Parameters
    parameter Real p2(unit = "bar") = 3.5          "Final pressure";
    parameter Real p1(unit = "bar") = 1            "Initial pressure";
    parameter Real T1(unit = "K") = 303            "Initial temperature";
    parameter Real T2(unit = "K") = 414            "Final temperature";
    parameter Real V2(unit = "m/s") = 90           "Final velocity";
    parameter Real Cp(unit = "kJ/kg*K") = 1.0035   "Specific heat at constant pressure for air";
    parameter Real R(unit = "kJ/kg*K") = 0.287     "Gas constant";
    final constant Real e = Modelica.Math.exp(1.0);
    // Equations
  equation
    Wa = Cp * (T1 - T2) - V2 ^ 2 * 1e-03 / 2;
    Wt = (-R * T1 * log(p2 / p1)) - V2 ^ 2 * 1e-03 / 2;
    nt = Wt / Wa * 100;
  end Ex8_20_c;
  
  //==============================================================================================
  
  model Ex8_20_d
  
    extends Modelica.Math;
    
    // Variables
    
    Real Wa(unit = "kJ/kg")                  "Actual work of compression";
    Real Wrev(unit = "kJ/kg")                "Decrease in avaiability or exergy";
    Real I(unit = "kJ/kg")                   "Ireversibility";
    
    // Parameters
    
    parameter Real p2(unit = "bar") = 3.5               "Final pressure";
    parameter Real p1(unit = "bar") = 1                 "Initial pressure";
    parameter Real T1(unit = "K") = 303                 "Initial temperature";
    parameter Real T2(unit = "K") = 414                 "Final temperature";
    parameter Real V2(unit = "m/s") = 90                "Final velocity";
    parameter Real Cp(unit = "kJ/kg*K") = 1.0035        "Specific heat at constant pressure for air";
    parameter Real R(unit = "kJ/kg*K") = 0.287          "Gas constant";
    
    final constant Real e = Modelica.Math.exp(1.0);
     
    // Equations
  
  equation
  
    Wa =Cp*(T1-T2)- (V2^2/2000);
    Wrev = (Cp*(T1-T2))-(T1*(R*log(p2/p1)-Cp*log(T2/T1)))-(V2^2/2000);
    I= Wrev-Wa;
    
    
    //The  answer may slightly vary due to  rounding off values
  end Ex8_20_d;
  
//===============================================================================================

  model Ex8_20_e
  
    extends Modelica.Math;
    
    // Variables
    
    Real Wa(unit = "kJ/kg")                  "Actual work of compression";
    Real Wrev(unit = "kJ/kg")                "Decrease in avaiability or exergy";
    Real n2(unit = "%")                      "Ireversibility";
    
    // Parameters
    
    parameter Real p2(unit = "bar") = 3.5               "Final pressure";
    parameter Real p1(unit = "bar") = 1                 "Initial pressure";
    parameter Real T1(unit = "K") = 303                 "Initial temperature";
    parameter Real T2(unit = "K") = 414                 "Final temperature";
    parameter Real V2(unit = "m/s") = 90                "Final velocity";
    parameter Real Cp(unit = "kJ/kg*K") = 1.0035        "Specific heat at constant pressure for air";
    parameter Real R(unit = "kJ/kg*K") = 0.287          "Gas constant";
    
    final constant Real e = Modelica.Math.exp(1.0);
     
    // Equations
  
  equation
  
    Wa =Cp*(T1-T2)- V2^2*1e-03/2;
    Wrev = Cp*(T1-T2)-T1*(R*log(p2/p1)-Cp*log(T2/T1))-(V2^2*1e-03)/2;
    n2=(Wa/Wrev)*100;
//The  answer may slightly vary due to  rounding off values.
  end Ex8_20_e;


end Ex8_20;
