model Ex8_4

extends Modelica.Math;
// Variables

Real AE_25(unit="kJ")                       "Available energy of 25 kg of water at 95 degree celsius";
Real AE_35(unit="kJ")                       "Available energy of 35 kg of water at 35 degree celsius";
Real AE_total1(unit="kJ")                   "Total available energy before mixing";
Real AE_total2(unit="kJ")                   "Total available energy after mixing";
Real T(unit="K")                            "Final temperature after mixing";
Real AE(unit="kJ")                          "Decrease in available energy due to mixing";

// Parameters
 parameter Real m(unit="kg")=60                 "Total mass after mixing";  //m=m1+m2
 parameter Real m1(unit="kg")=25                "Mass 1"; 
 parameter Real m2(unit="kg")=35                "Mass 2";  
 parameter Real Cp(unit="kJ/kg*K")=4.2          "Speific heat at constant pressure"; 
 parameter Real T0(unit="K")=288                "Surounding temperature"; 
 parameter Real T1(unit="K")=368                "Initial temperature"; 
 parameter Real T2(unit="K")=308                "Final temperature";   
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation

AE_25=m1*Cp*((T1-T0)-T0*log(T1/T0));
AE_35=m2*Cp*((T2-T0)-T0*log(T2/T0));
AE_total1=AE_25+AE_35;
T=(m1*T1+m2*T2)/(m1+m2);
AE_total2=m*Cp*((T-T0)-T0*log(T/T0));
AE=AE_total1-AE_total2;

end Ex8_4;
