package Ex8_8

model Ex8_8_a
extends Modelica.Math;
// Variables

Real w1(unit="kJ/kg")                       "Initial availability of the products";
Real w2(unit="kJ/kg")                       "Final availability of the products";

// Parameters
 
 
 parameter Real Cp(unit="kJ/kg*K")=1.09           "Speific heat at constant volume"; 
 parameter Real T0(unit="K")=300                   "Surounding temperature"; 
 parameter Real T1(unit="K")=573                   "Initial air temperature" ; 
 parameter Real T2(unit="K")=473                   "Final air temperature" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

w1=Cp*(T1-T0)-T0*Cp*log(T1/T0);
w2=Cp*(T2-T0)-T0*Cp*log(T2/T0);

end Ex8_8_a;
//====================================================================================================

model Ex8_8_b
extends Modelica.Math;
// Variables

Real w1(unit="kJ/kg")                       "Initial availability of the products";
Real w2(unit="kJ/kg")                       "Final availability of the products";
Real delta_w_g(unit="kJ/kg")                "Decrease in availability of the products";
Real delta_w_a(unit="kJ/kg")                "Increase in availability of the air";
Real Ta2(unit="K")                          "Final temperature of air";
Real I(unit="kW")                           "Irreversibility of the process";

// Parameters
 
 parameter Real m_g(unit="kg/s")=12.5             "Rate of flow of products"; 
 parameter Real m_a(unit="kg/s")=11.15            "Rate of flow of air"; 
 parameter Real Cp_g(unit="kJ/kg*K")=1.09         "Speific heat of product at constant volume"; 
 parameter Real Cp_a(unit="kJ/kg*K")=1.005        "Speific heat of air at constant volume"; 
 parameter Real T0(unit="K")=300                  "Surounding temperature"; 
 parameter Real Tg1(unit="K")=573                 "Initial temperature of product" ; 
 parameter Real Tg2(unit="K")=473                 "Final temperature of product" ;
 parameter Real Ta1(unit="K")=313                 "Initial temperature of air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

w1=Cp_g*(Tg1-T0)-T0*Cp_g*log(Tg1/T0);
w2=Cp_g*(Tg2-T0)-T0*Cp_g*log(Tg2/T0);
delta_w_g=w1-w2;
Ta2=Ta1+((m_g*Cp_g*(Tg1-Tg2))/(m_a*Cp_a));
delta_w_a=(Cp_a*(Ta2-Ta1))-(T0*Cp_a*log(Ta2/Ta1));
I=(m_g*delta_w_g)-(m_a*delta_w_a);

//The given answer in the book is wrong. Please check.
end Ex8_8_b;

//==================================================================================================

model Ex8_8_c
extends Modelica.Math;
// Variables

Real Ta2(unit="K")      "Final temperature of air";
Real Q1(unit="kW")      "Rate of heat supply from the gas to the working fluid in the heat engine";
Real Q2(unit="kW")      "Rate of heat rejection from the working fluid in the heat engine to the air";
Real W(unit="kW")       "Total power developed by the heat engine";

// Parameters
 
 parameter Real m_g(unit="kg/s")=12.5             "Rate of flow of products"; 
 parameter Real m_a(unit="kg/s")=11.15            "Rate of flow of air"; 
 parameter Real Cp_g(unit="kJ/kg*K")=1.09         "Speific heat of product at constant volume"; 
 parameter Real Cp_a(unit="kJ/kg*K")=1.005        "Speific heat of air at constant volume"; 
 parameter Real Tg1(unit="K")=573                 "Initial temperature of product" ; 
 parameter Real Tg2(unit="K")=473                 "Final temperature of product" ;
 parameter Real Ta1(unit="K")=313                 "Initial temperature of air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

m_g*Cp_g*log(Tg2/Tg1)=-m_a*Cp_a*log(Ta2/Ta1);
Q1=m_g*Cp_g*(Tg1-Tg2);
Q2=m_a*Cp_a*(Ta2-Ta1);
W=Q1-Q2;

//The  answer may slightly vary due to  rounding off values.
end Ex8_8_c;




end Ex8_8;
