model Ex9_13

extends Modelica.Math;

// Variables
Real m(unit="kg")                             "Total mass of mixture";
Real v1(unit="m^3/kg")                        "Specific volume of 1st chamber";
Real V1(unit="m^3")                           "Volume of 1st chamber";
Real v2(unit="m^3/kg")                        "Specific volume of 2nd chamber";
Real V2(unit="m^3")                           "Volume of 2nd chamber";
Real Vm(unit="m^3")                           "Total volume of mixture";
Real vm(unit="m^3/kg")                        "Specific volume of mixture";
Real h1(unit="kJ/kg")                         "Enthalpy of 1st chamber";
Real u1(unit="kJ/kg")                         "Internal energy of 1st chamber";
Real u2(unit="kJ/kg")                         "Internal energy of 2nd chamber";
Real h2(unit="kJ/kg")                         "Enthalpy of 2nd chamber";
Real h3(unit="kJ/kg")                         "Enthalpy of mixture";
Real s2(unit="kJ/kg*K")                       "Entropy of 2nd chamber";
Real delta_s(unit="kJ/kg*K")                  "Entropy change during the process";


// Parameters
  parameter Real m1(unit="kg")=5               "Mass of 1st chamber";
  parameter Real m2(unit="kg")=10              "Mass of 2nd chamber";
  parameter Real x1(unit="")=1                 "dryness fraction";
  parameter Real x2(unit="")=0.8               "dryness fraction";
  parameter Real p1(unit="MPa")=0.2            "Pressure";
  parameter Real p2(unit="MPa")=0.5            "Pressure";
  
 // From the mollier diagram,at 0.2 MPa and 400 degree celsius
 
 parameter Real vg(unit="m^3/kg")=0.8857             "Specific volume of gas";
 parameter Real hg(unit="kJ/kg")=2706.7             "Enthalpy of gas";
 
 // From the mollier diagram,at 0.5 MPa and 20 degree celsius
 
 parameter Real vf(unit="m^3/kg")=0.001093         "Specific volume of fluid";
 parameter Real vfg(unit="m^3/kg")=0.3749            "Specific volume";
 parameter Real hf(unit="kJ/kg")=640.23             "Enthalpy of fluid";
 parameter Real hfg(unit="kJ/kg")=2108.5            "Enthalpy ";
 
 // From the mollier diagram,with the given h and v, point 3 after mixing is fixed.
 parameter Real x3(unit="")=0.870                     "Dryness fraction of mixture";
 parameter Real s3(unit="kJ/kg*K")=6.29               "Entropy";
 parameter Real p3(unit="bar")=3.5                    "Pressure of mixture";
 parameter Real s1(unit="kJ/kg*K")=7.1271             "Entropy";
 parameter Real sf(unit="kJ/kg*K")=1.8607             "Entropy";
 parameter Real sfg(unit="kJ/kg*K")=4.9606            "Entropy";
 
final constant Real e=Modelica.Math.exp(1.0);
final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;

 // Equations

equation
v1=vg;
V1=m1*v1;
v2=vf+x2*vfg;
V2=m2*v2;
Vm=V1+V2;
m=m1+m2;
vm=Vm/m;
h1=hg;
u1=h1-p1*v1;
h2=hf+x2*hfg;
u2=h2-p2*v2;
h3=(m1*h1+m2*h2)/m;
s2=sf+x2*sfg;
delta_s=m*s3-(m1*s1+m2*s2);

end Ex9_13;
