model Ex9_6


// Variables
Real T0(unit="degree celsius")                       "Temperature";
Real x(unit="")                                      "Quality of mixture";
Real h2(unit="kJ/kg")                                "Enthalpy";
Real Q(unit="kJ/kg")                                 "Heat transfer";


// Parameters
 // According to steam table,at 0.3 Mpa t_sat=250 degree celsius since t>t_sat,the state would be in the superheated region. For properties of superheated steam, at 0.3 MPa, 250 degree celsius. 
 parameter Real p1(unit="kPa")=300                   "Pressure";
 parameter Real v1(unit="m^3/kg")=0.7964             "Specific volume"; 
 parameter Real h1(unit="kJ/kg")=2967.6              "Enthalpy";
 
 parameter Real vg1(unit="m^3/kg")=0.8919           "Specific volume of gas";
 parameter Real vg2(unit="m^3/kg")=0.77076          "Specific volume of gas";
 parameter Real v0(unit="m^3/kg")=0.7964            "Specific volume";
 parameter Real T1(unit="Degree celsius")=120       "Temperature";
 parameter Real T2(unit="Degree celsius")=125       "Temperature";
 //At 80 degree celsius
 parameter Real hf(unit="kJ/kg")=334.91              "Enthalpy of liquid";
 parameter Real hfg(unit="kJ/kg")=2308.8             "Enthalpy";
 parameter Real p2(unit="kPa")=47.39                 "Saturated pressure";
 parameter Real vf(unit="m^3/kg")=0.001029           "Specific volume of fluid"; 
 parameter Real vg(unit="m^3/kg")=3.407              "Specific volume of gas"; 
 
 
 // Equations

equation
//by interpolation
T0=T1+((v0-vg1)*(T2-T1)/(vg2-vg1));
x=(v1-vf)/(vg-vf);
h2=hf+x*hfg;
Q=(h2-h1)+v1*(p1-p2);


end Ex9_6;
