model Ex9_8

// Variables

Real h2(unit="kJ/kg")                           "Enthalpy";
Real h3(unit="kJ/kg")                           "Enthalpy";
Real t3(unit="degree celsius")                  "Temperature";
Real DS(unit="degree celsius")                  "Degree of superheat";
Real s4(unit="kJ/kg*K")                         "Entropy";
Real x4(unit="")                                "Dryness fraction";
Real h4(unit="kJ/kg")                           "Enthalpy";
Real V4(unit="m/s")                             "Velocity";


// Parameters
 parameter Real w1(unit="kg/s")=1                   "Mass flow rate of steam";
 parameter Real w2(unit="kg/s")=1.3                 "Mass flow rate of steam";
 parameter Real w3(unit="kg/s")=2.3                 "Mass flow rate of steam";

 // According to steam table,at 250 degree celsius and 0.8 MPa
 parameter Real h1(unit="kJ/kg")=2950.0              "Enthalpy";
 parameter Real x(unit="")=0.95                      "Dryness fraction";

 parameter Real hfg(unit="kJ/kg")=2048               "Enthalpy";
 parameter Real hf(unit="kJ/kg")=721.11              "Enthalpy of liquid";
 // According to steam table,200 degree celsius and 10.8 MPa
 
 parameter Real tsat(unit="degree celsius")=170.43           "Saturated temperature";
 parameter Real h(unit="kJ/kg")=3037.6                  "Enthalpy";
 
 parameter Real s3(unit="kJ/kg*K")= 6.7087              "Entropy";
 parameter Real sf(unit="kJ/kg*K")= 1.7766              "Entropy";
 parameter Real sfg(unit="kJ/kg*K")= 5.1193             "Entropy";
 parameter Real h_f(unit="kJ/kg")=604.74                "Enthalpy";
 parameter Real h_fg(unit="kJ/kg")=2133.8               "Enthalpy";
 
 // Equations

equation

h2=hf+x*hfg;
h3=(w1*h1+w2*h2)/w3;
t3=179;                     //By interpolation
DS=t3-tsat; 
s4 = s3;
x4 = (s3-sf)/sfg;
h4 = h_f+(x4*h_fg);
V4 = sqrt(2000*(h3-h4));


end Ex9_8;
