package Ex1_3

//=================================================================================================
model Ex1_3_a                                         //40cm_Hg_vacuum

// Variables
Real P_vacuum(unit="kpa")                          "vacuum pressure";
Real P_abs(unit="kpa")                             "absolute pressure";

// Parameters
 parameter Real z0(unit="m")=760e-03               "reading of barometer";
 parameter Real rho(unit="kg/m^3")=13.6e03         "density of mercury";
 parameter Real g(unit="m/s^2")=9.81               "acceleration due to gravity";
 parameter Real z(unit="m")=40e-02                 "difference in height";
 
// Equations
equation

P_vacuum=(rho*g*z)/1e03;                            //vacuum pressure
P_abs=(rho*g*(z0-z))/1e03;                          //absolute pressure


end Ex1_3_a;

//========================================================================================

model Ex1_3_b                                               //90cm_Hg_gauge

// Variables
Real P_gauge(unit="kpa")                                 "Gauge pressure";
Real P_abs(unit="kpa")                                   "absolute pressure";

// Parameters
 parameter Real z0(unit="m")=760e-03                      "reading of barometer";
 parameter Real rho(unit="kg/m^3")=13.6e03                "density of mercury";
 parameter Real g(unit="m/s^2")=9.81                      "acceleration due to gravity";
 parameter Real z(unit="m")=90e-02                        "difference in height";
 
// Equations
equation

P_gauge=(rho*g*z)/1e03;                                    //Gauge pressure
P_abs=(rho*g*(z0+z))/1e03;                                 //absolute pressure

end Ex1_3_b;

//==========================================================================================

model Ex1_3_c                                             //1.2m_H2o_gauge

// Variables
Real P_gauge(unit="kpa")                               "Gauge pressure";
Real P_abs(unit="kpa")                                 "absolute pressure";

// Parameters
 parameter Real z0(unit="m")=760e-03                   "reading of barometer";
 parameter Real rho(unit="kg/m^3")=1000                "density of water";
 parameter Real g(unit="m/s^2")=9.81                   "acceleration due to gravity";
 parameter Real z(unit="m")=1.2                        "difference in height";
 parameter Real P_atm(unit= "kpa")=101.325             "atmospheric pressure";
 
// Equations 
equation

P_gauge=(rho*g*z)/1e03;                                //Gauge pressure
P_abs=P_gauge+P_atm;                                   //absolute pressure 

end Ex1_3_c;

//======================================================================================
end Ex1_3;




