model Ex1_4
extends Modelica.Math;
// Variable

Real h(unit ="m")                       "Depth of the atmosphere";
Real p(unit ="Pa")                      "Pressure";

// Parameters

  parameter Real g(unit ="m/s^2")=9.8                   "Gravitational acceleration";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

der(h)=(1/g)*((2.5e05/p)^(1/1.4));
p=time;

//Simulation process has done from the limit 0.00000000001 Pa to 1.033e05 Pa.
//Initial value(0.00000000001 Pa) has taken to avoid invalid syntax error(1/0)
//Start time=0.0000001 sec
//Stop time=1.033e05 sec

end Ex1_4;
