package Ex10_1

model Ex10_1_a          
//The fluid is air

// Variables
Real T2(unit="K")                         "Final temperature";
Real m(unit="kg")                         "Mass";
Real Q(unit="kJ")                         "Heat transferred";


// Parameters
  parameter Real V1(unit="m^3")=0.8                 "Volume at state 1";
  parameter Real T1(unit="K")=573                   "Temperature at state 1";
  parameter Real p1(unit="kPa")=100                 "Pressure at state 1";
  parameter Real p2(unit="kPa")=50                  "Pressure at state 2";
  parameter Real R(unit="kJ/kg*K")=0.287            "Gas constant";
  parameter Real Cv(unit="kJ/kg*K")=0.718           "Specific heat at constant volume";
  
 // Equations
equation

T2=p2*T1/p1;
m=p1*V1/(R*T1);
Q=m*Cv*(T2-T1);

end Ex10_1_a;
//==============================================================================================

model Ex10_1_b         

//The fluid is steam

// Variables
Real v2(unit="m^3/kg")                         "Final Specific volume";
Real x2(unit="")                               "Dryness fraction";
Real u2(unit="kJ/kg")                          "Internal energy";
Real m(unit="kg")                              "Mass";
Real Q(unit="kJ")                              "Heat transferred";
Real T2(unit="K")                              "Temperature";


// Parameters
  parameter Real p2(unit="kPa")=50                             "Pressure";
  parameter Real V(unit="m^3")=0.8                             "Volume";
  //from steam table, at 200kPa and 300 degree celsius
  parameter Real t2(unit="degree celsius")=81.33               "Temperature";
  parameter Real vf(unit="m^3/kg")=0.00103                     "Specific volume";
  parameter Real vg(unit="m^3/kg")=3.24                        "Specific volume";
  
  //from steam table, at 100kPa and 300 degree celsius
  parameter Real u1(unit="kJ/kg")=2810.4                       "Internal energy";
  parameter Real v1(unit="m^3/kg")=2.6388                      "Specific volume";
  parameter Real uf(unit="kJ/kg")=340.42                       "Internal energy";
  parameter Real ufg(unit="kJ/kg")=2143.4                      "Internal energy";
  
  
 // Equations
equation
v2=v1;
x2=(v2-vf)/(vg-vf);
u2=uf+x2*ufg;
m=V/v1;
Q=m*(u2-u1);
T2=t2+273;

//The  answer may slightly vary due to  rounding off values.
end Ex10_1_b;



end Ex10_1;
