model Ex10_12

extends Modelica.Math;
// Variables

Real m(unit ="kg")                              "Mass";
Real T2(unit ="K")                              "Temperature at point 2";
Real T3(unit ="K")                              "Temperature at point 3";
Real p2_p3(unit ="")                            "Pressure ratio";
Real p1_p3(unit ="")                            "Pressure ratio";
Real Q1_2(unit ="kJ")                           "Heat transfer in process 1-2";
Real Q2_3(unit ="kJ")                           "Heat transfer in process 2-3";
Real Q3_1(unit ="kJ")                           "Heat transfer in process 3-1";
Real Q1(unit ="kJ")                             "Heat recieved in the cycle";
Real Q2(unit ="kJ")                             "Heat rejected in the cycle";
Real n_cycle(unit ="%")                         "Efficiency of the cycle";

// Parameters
  
  parameter Real p1(unit ="kPa")=700                "Pressure at point 1";
  parameter Real V1(unit ="m^3")=0.028              "Volume at point 1";
  parameter Real V2(unit ="m^3")=0.084              "Volume at point 2";
  parameter Real T1(unit ="K")=533                  "Temperature at point 1";
  parameter Real R(unit ="KJ/kg K")=0.287           "Gas constant";
  parameter Real y(unit ="")=1.4                    "Specific heat ratio";
  parameter Real n(unit ="")=1.5                    "Polytropic index";
  parameter Real Cp(unit ="KJ/kg K")=1.005          "Specific heat at constant pressure";
  parameter Real Cv(unit ="KJ/kg K")=0.718          "Specific heat at constant volume";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

m=(p1*V1)/(R*T1);
T3=T1;
T2=T1*(V2/V1);
p2_p3=(T2/T3)^(n/(n-1));
p1_p3=p2_p3;
Q1_2=m*Cp*(T2-T1);
Q2_3=m*Cv*(T3-T2)*((n-y)/(n-1));
Q3_1=m*R*T1*log(1/p1_p3);
Q1=Q1_2;
Q2=-(Q2_3+Q3_1);
n_cycle=(1-(Q2/Q1))*100;

//The  answer may slightly vary due to  rounding off values.

end Ex10_12;
