model Ex11_3

extends Modelica.Math;
// Variables

Real P(unit ="kPa")              "Pressure of carbon dioxide";


// Parameters
  

  parameter Real R(unit ="kJ/kg*K")=8.3143         "Gas constant";
  parameter Real Tb(unit ="K")=353                 "Boiling point of benzene";
  parameter Real T(unit ="K")=303                  "Benzene temperature";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

P=101.325*exp((88/R)*(1-(Tb/T)));

end Ex11_3;
