model Ex12_4


extends Modelica.Math;
// Variables

Real Wp(unit ="kJ/kg")                       "Pump work";
Real Wt(unit ="kJ/kg")                       "Turbine work";
Real W_net(unit ="kJ/kg")                    "Work done";
Real Q1(unit ="kJ/kg")                       "Heat transfer";
Real n(unit ="%")                            "Cyclic efficiency";
Real Steam_rate(unit ="kg/kW h")             "Steam rate";

// Parameters
  
//steam is a saturated liquid initially.
  parameter Real h1(unit ="kJ/kg")=3465               "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=3065               "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=3565               "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=2300               "Enthalpy";
  parameter Real h5(unit ="kJ/kg")=191.83             "Enthalpy";
  parameter Real h6(unit ="kJ/kg")=206.83             "Enthalpy";
  parameter Real v(unit ="m^3/kg")=0.001              "Specific Volume";
  parameter Real P(unit ="kPa")=150e02                "Pressure";
  
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

Wp=v*P;
Q1=(h1-h6)+(h3-h2);
Wt=(h1-h2)+(h3-h4);
W_net=Wt-Wp;
n=W_net*100/Q1;
Steam_rate=3600/W_net;

//Rounding off error.

end Ex12_4;
