model Ex12_5

extends Modelica.Math;
// Variables
Real s3(unit ="kJ/kg*K")                 "Entropy";
Real s2(unit ="kJ/kg*K")                 "Entropy";
Real x3(unit ="")                        "Dryness fraction";
Real h3(unit ="kJ/kg")                   "Enthalpy";
Real h4(unit ="kJ/kg")                   "Enthalpy";
Real h5(unit ="kJ/kg")                   "Enthalpy";
Real h7(unit ="kJ/kg")                   "Enthalpy";
Real m(unit ="kg")                       "Mass";
Real Wt(unit ="kJ/kg")                   "Turbine work";
Real Q1(unit ="kJ/kg")                   "Heat transfer";
Real n_cycle(unit ="%")                  "Cyclic efficiency";
Real steam_rate(unit ="kg/kW*hr")        "Steam rate";
Real Tm1(unit ="K")                      "Mean temperature";
Real Tm(unit ="K")                       "Mean temperature";
Real dT(unit ="K")                       "Increase in Tm due to generation";
Real Wt_(unit ="kJ/kg")                  "Turbine work without regeneration";
Real steam_rate_(unit ="kg/kW*hr")       "Steam rate without regeneration";
Real delta_sr(unit ="kg/kW*hr")          "Increase in Steam rate due to generation";
Real n_cycle_(unit ="%")                 "Cyclic efficiency";
Real dn(unit ="%")                       "Increase in cyclic efficiency due to generation";

// Parameters
  
//steam is a saturated liquid initially.
  parameter Real h1(unit ="kJ/kg")=3230.9               "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=2796                 "Enthalpy";
  parameter Real h6(unit ="kJ/kg")=640.23               "Enthalpy";
  parameter Real hfg(unit ="kJ/kg")=2392.8              "Enthalpy";
  parameter Real hf(unit ="kJ/kg")=191.83               "Enthalpy";
  parameter Real s1(unit ="kJ/kg*K")=6.9212             "Entropy";
  parameter Real sfg(unit ="kJ/kg*K")=7.5009            "Entropy";
  parameter Real sf(unit ="kJ/kg*K")=0.6493             "Entropy";
  parameter Real s4(unit ="kJ/kg*K")=0.6493             "Entropy";
  parameter Real s7(unit ="kJ/kg*K")=1.8607             "Entropy";
  parameter Real x2(unit ="")=0.85                      "Dryness fraction";
  parameter Real vf(unit ="m^3/kg")=0.001               "Specific Volume";
  parameter Real P1(unit ="bar")=0.08                   "Pressure";
  
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

s2=s1;
s3=s2;
x3 = (s3-sf)/sfg;
h3 = hf + x3*hfg;
h4 = hf; 
h5 = h4;
h7 = h6;
m*(h2-h6)=(1-m)*(h6-h5);
Wt = (h1-h2)+(1-m)*(h2-h3);
Q1 = h1-h6;
n_cycle = 100*Wt/Q1;
steam_rate = 3600/Wt;
Tm = (h1-h7)/(s1-s7);
Tm1 = (h1-h4)/(s1-s4); 			// Without regeneration
dT = Tm-Tm1;
Wt_ = h1-h3;
steam_rate_ = 3600/Wt_;
delta_sr = steam_rate-steam_rate_;
n_cycle_ = 100*(h1-h3)/(h1-h4);
dn = n_cycle-n_cycle_;

//The  answer provided in the textbook is wrong.
end Ex12_5;
