model Ex12_6


extends Modelica.Math;
// Variables
Real dt(unit ="degree celsius")                 "Temperature";
Real t(unit ="degree celsius")                  "Temperature";
Real t1(unit ="degree celsius")                 "Temperature";
Real t2(unit ="degree celsius")                 "Temperature";
Real x2(unit ="")                               "Dryness fraction";
Real h2(unit ="kJ/kg")                          "Enthalpy";
Real x3(unit ="")                               "Dryness fraction";
Real h3(unit ="kJ/kg")                          "Enthalpy";
Real x4(unit ="")                               "Dryness fraction";
Real h4(unit ="kJ/kg")                          "Enthalpy";
Real h5(unit ="kJ/kg")                          "Enthalpy";
Real h6(unit ="kJ/kg")                          "Enthalpy";
Real h7(unit ="kJ/kg")                          "Enthalpy";
Real h8(unit ="kJ/kg")                          "Enthalpy";
Real h10(unit ="kJ/kg")                         "Enthalpy";
Real m1(unit ="kg")                             "Mass";
Real m2(unit ="kg")                             "Mass";
Real Wt(unit ="kJ/kg")                          "Turbine work";
Real Wp(unit ="kJ/kg")                          "Pump work";
Real Q1(unit ="kJ/kg")                          "Heat transfer";
Real n_cycle(unit ="%")                         "Cyclic efficiency";
Real sr(unit ="kg/kW*hr")                       "Steam rate";

// Parameters
  parameter Real h1(unit ="kJ/kg")=3023.5                "Enthalpy";
  parameter Real s1(unit ="kJ/kg*K")=6.7664              "Entropy";
//From steam table, at 0.1 bar

  parameter Real hfg(unit ="kJ/kg")=2392.8               "Enthalpy";
  parameter Real hf(unit ="kJ/kg")=191.83                "Enthalpy";
  parameter Real sg(unit ="kJ/kg*K")=8.1502              "Entropy";
  parameter Real sf(unit ="kJ/kg*K")=0.6493              "Entropy";
//From steam table, at 100 degree celsius  
  parameter Real hfg100(unit ="kJ/kg")=2257.0            "Enthalpy";
  parameter Real hf100(unit ="kJ/kg")=419.04             "Enthalpy";
  parameter Real sg100(unit ="kJ/kg*K")=7.3549           "Entropy";
  parameter Real sf100(unit ="kJ/kg*K")=1.3069           "Entropy";
//From steam table, at 150 degree celsius  
  parameter Real hfg150(unit ="kJ/kg")=2114.3            "Enthalpy";
  parameter Real hf150(unit ="kJ/kg")=632.20             "Enthalpy";
  parameter Real sg150(unit ="kJ/kg*K")=6.8379           "Entropy";
  parameter Real sf150(unit ="kJ/kg*K")=1.8418           "Entropy";
    
  parameter Real n(unit ="units")=3                      "Number of units";
  parameter Real h9(unit ="kJ/kg")=632.2                 "Enthalpy";
  
  parameter Real t_sat_20(unit ="degree celsius")=212         "Saturated temperature";
  parameter Real t_sat_1(unit ="degree celsius")=46           "Saturated temperature";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

dt = t_sat_20-t_sat_1;
t = dt/n;
t1 = t_sat_20-t;
t2 = t1-t;
x2 = (s1-sf150)/(sg150-sf150);
h2 = hf150+(x2*hfg150);
x3 = (s1-sf100)/(sg100-sf100);
h3 = hf100+(x3*hfg100);
x4 = (s1-sf)/(sg-sf);
h4 = hf+(x4*hfg);
h5 = hf; 
h6 = h5;
h7 = hf100; 
h8 = h7; 
h10 = h9;
m1 = (h9-h7)/(h2-h7);
m2 = ((1-m1)*(h7-h6))/(h3-h6);
Wt = 1*(h1-h2)+(1-m1)*(h2-h3)+(1-m1-m2)*(h3-h4);
Q1 = h1-h9;
Wp = 0 ; 			// Pump work is neglected
n_cycle = 100*(Wt-Wp)/Q1;
sr = 3600/(Wt-Wp);

end Ex12_6;
