package Ex12_8

model Ex12_8_a
//Basic Rankine cycle
extends Modelica.Math;
// Variables

Real Wt(unit ="kJ/kg")                       "Turbine work";
Real Wp(unit ="kJ/kg")                       "Pump work";
Real Q1(unit ="kJ/kg")                       "Heat input";
Real Wnet(unit ="kJ/kg")                     "Net work";
Real n1(unit ="")                            "Efficiency";
Real WR(unit ="")                            "Work ratio";
Real wg(unit ="")                            "";
Real P0(unit ="MW")                          "Power output";
Real EIR(unit ="MW")                         "Exergy input rate";
Real n2(unit ="")                            "Second law efficiency";

// Parameters
  //From steam table, at 40 bar
  parameter Real h1(unit ="kJ/kg")=2758             "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=1817             "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=192              "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=200              "Enthalpy";
  parameter Real Q(unit ="MW")=100                  "Heat input rate";
  parameter Real Cpg(unit ="kJ/kg*K")=1             "Specific heat at constant pressure";
  parameter Real Te(unit ="K")=450                  "Exhaust temperature";
  parameter Real To(unit ="K")=300                  "Atmospheric temperature";
  parameter Real Ti(unit ="K")=833                  "Temperature of hot gases";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

Wt = h1-h2; 
Wp = h4-h3;
Q1 = h1-h4; 
Wnet = Wt-Wp;
n1 = Wnet/Q1;
WR = Wnet/Wt;
P0= n1*Q;
wg = (Q/(Ti-Te));
EIR = wg*Cpg*((Ti-To)-To*log(Ti/To));
n2 = P0/EIR ;

end Ex12_8_a;

//==============================================================================================

model Ex12_8_b
//Rankine cycle with superheat
extends Modelica.Math;
// Variables

Real Wt(unit ="kJ/kg")                    "Turbine work";
Real Wp(unit ="kJ/kg")                    "Pump work";
Real Q1(unit ="kJ/kg")                    "Heat input";
Real Wnet(unit ="MW")                  "Net work";
Real n1(unit ="")                         "Efficiency";
Real WR(unit ="")                         "Work ratio";
Real n2(unit ="")                         "Second law efficiency";

// Parameters
  //From steam table, in superheated region
  parameter Real h1(unit ="kJ/kg")=3398             "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=2130             "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=192              "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=200              "Enthalpy";
  parameter Real EIR(unit ="MW")=59.3               "Exergy input rate";
  parameter Real Q(unit ="MW")=100                  "Heat input rate";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

Wt = h1-h2; 
Wp = h4-h3;
Q1 = h1-h4;
n1 = (Wt-Wp)/Q1;
WR = (Wt-Wp)/Wt;
Wnet= n1*Q;
n2 = Wnet/EIR ;

end Ex12_8_b;
//================================================================================================


model Ex12_8_c
//Rankine cycle with reheat
extends Modelica.Math;
// Variables
Real Wt1(unit ="kJ/kg")                   "Turbine work";
Real Wt2(unit ="kJ/kg")                   "Turbine work";
Real Wt(unit ="kJ/kg")                    "Turbine work";
Real Wp(unit ="kJ/kg")                    "Pump work";
Real Q1(unit ="kJ/kg")                    "Heat input";
Real MPO(unit ="MW")                      "Mechanical power output";
Real Wnet(unit ="kJ/kg")                  "Net work";
Real n1(unit ="")                         "Efficiency";
Real WR(unit ="")                         "Work ratio";
Real n2(unit ="")                         "Second law efficiency";

// Parameters
  //From steam table, in superheated region
  parameter Real h1(unit ="kJ/kg")=3398             "Enthalpy";
  parameter Real h2(unit ="kJ/kg")=2761             "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=3482             "Enthalpy";
  parameter Real h4(unit ="kJ/kg")=2522             "Enthalpy";
  parameter Real h5(unit ="kJ/kg")=192              "Enthalpy";
  parameter Real h6(unit ="kJ/kg")=200              "Enthalpy";
  parameter Real EIR(unit ="MW")=59.3               "Exergy input rate";
  parameter Real Q(unit ="MW")=100                  "Heat input";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation

Wt1 = h1-h2; 
Wt2 = h3-h4;
Wt = Wt1+Wt2; 
Wp = h6-h5;
Q1 = (h1-h6)+(h3-h2);
n1 = (Wt-Wp)/Q1;
MPO = n1*Q;
WR = (Wt-Wp)/Wt;
Wnet= Wt-Wp;
n2 = MPO/EIR ;

end Ex12_8_c;
//================================================================================================

model Ex12_8_d
//Rankine cycle with complete regeneration

extends Modelica.Math;
// Variables

Real n1(unit ="")                 "Efficiency";
Real Q1(unit ="kJ/kg")            "Heat input";
Real Wnet(unit ="kJ/kg")          "Net work";
Real WR(unit ="")                 "Work ratio";
Real wg(unit ="")                 "Mass flow rate";
Real P0(unit ="MW")               "Power output";
Real EIR(unit ="MW")              "Exergy input rate";
Real n2(unit ="")                 "Second law efficiency";

// Parameters

  //From steam table, at 0.1 bar
  parameter Real T3(unit ="K")=318.8               "Temperature";
  //From steam table, at 80 bar
  parameter Real T1(unit ="K")=568                 "Temperature";

  parameter Real Wp(unit ="kJ/kg")=8               "Pump work";
  parameter Real Wt(unit ="kJ/kg")=641             "Turbine work";
  parameter Real h1(unit ="kJ/kg")=2758            "Enthalpy";
  parameter Real h6(unit ="kJ/kg")=1316            "Enthalpy";
  parameter Real Q(unit ="MW")=100                 "Heat input rate";
  parameter Real Cpg(unit ="kJ/kg*K")=1            "Specific heat";
  
  parameter Real Te(unit ="K")=593                 "Exhaust temperature";
  parameter Real To(unit ="K")=300                 "Atmospheric temperature";
  parameter Real Ti(unit ="K")=833                 "Temperature of hot gases";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations

equation
n1 = 1-(T3/T1);
Q1 = h1-h6; 
Wnet = Q1*n1;
WR = Wnet/Wt;
P0= n1*Q;
wg = (Q/(Ti-Te));
EIR = wg*Cpg*((Ti-To)-To*log(Ti/To));
n2 = P0/EIR ;

end Ex12_8_d;

end Ex12_8;