model Ex13_2

extends Modelica.Math;
// Variables

Real n_diesel(unit ="")                         "Diesel Efficiency";
Real rc(unit ="")                               "Cut-off ratio";

// Parameters
  //From steam table, at 40 bar
  parameter Real rk(unit ="")=14              "Compression ratio";  
  parameter Real k(unit ="")=0.06             "Cut-off ratio";
  parameter Real y(unit ="")=1.4              "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
rc = k*(rk-1)+1;
n_diesel = 1-((1/y))*(1/rk^(y-1))*((rc^(y-1))/(rc-1));

//The  answer may slightly vary due to  rounding off values.

end Ex13_2;
