model Ex13_3

extends Modelica.Math;
// Variables

Real v1_2(unit ="")                  "Specific volume ratio";         //V1/V2
Real T2(unit ="K")                   "Temperature";
Real rc(unit ="")                    "Cut off ratio";
Real Q1(unit ="kJ/kg")               "Heat supplied";
Real v3_2(unit ="")                  "Specific volume ratio";         //V3/V2
Real T4(unit ="K")                   "Temperature";
Real Q2(unit ="kJ/kg")               "Heat rejected";
Real n_cycle(unit ="%")              "Cyclic Efficiency";
Real n_cycle1(unit ="%")             "Cyclic Efficiency";
Real Wnet(unit ="kJ/kg")             "Net work done";
Real v1(unit ="m^3/kg")              "Specific volume";
Real v2(unit ="m^3/kg")              "Specific volume";
Real Pm(unit ="kPa")                 "Mean effective pressure";

// Parameters
  
  parameter Real rk(unit ="")=16                    "Compression ratio";  
  parameter Real T1(unit ="K")=288                  "Temperature";
  parameter Real T3(unit ="K")=1753                 "Temperature";
  parameter Real p1(unit ="MPa")=0.1                "Pressure";
  parameter Real Cp(unit ="kJ/kg*K")=1.005          "Specific heat at constant pressure";
  parameter Real Cv(unit ="kJ/kg*K")=0.718          "Specific heat at constant volume";
  parameter Real y(unit ="")=1.4                    "Specific heat ratio";
  parameter Real R(unit ="kJ/kg*K")=0.287           "Gas constant";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
v1_2=rk;
T2=T1*((v1_2)^(y-1));
rc=T3/T2;
Q1=Cp*(T3-T2);
v3_2=rc;
T4=T3/((v1_2/v3_2)^(y-1));
Q2=Cv*(T4-T1);
n_cycle=(1-(Q2/Q1))*100;
n_cycle1=(1-((1/y)*(1/rk^(y-1))*((rc^y)-1)/(rc-1)))*100; 
Wnet = Q1*n_cycle/100;
v1 = (R*T1)/(p1*1e03) ;
v2 = v1/rk;
Pm = Wnet/(v1-v2);


//The  answer may slightly vary due to  rounding off values.
end Ex13_3;
