model Ex14_3

extends Modelica.Math;
// Variables


Real h4(unit ="kJ/kg")                       "Enthalpy";
Real s2(unit ="kJ/kg*K")                     "Entropy";
Real t2(unit ="degree celsius")              "Temperature";
Real h2(unit ="kJ/kg")                       "Enthalpy";
Real C(unit ="kJ/h")                         "Capacity of plant";
Real w(unit ="kg/s")                         "Refrigerant flow rate";
Real V(unit ="m^3/s")                        "Volume flow rate";
Real p(unit ="")                             "Pressure ratio";
Real Q2(unit ="kW")                          "Heat rejected to the condenser";
Real x4(unit ="")                            "Dryness fraction";
Real COP(unit ="")                           "Coefficient of performance";
Real P(unit ="kW")                           "Power required to drive the compressor";
Real COP_rev(unit ="")                       "Reversible Coefficient of performance";
Real E(unit ="")                             "Coefficient of performance ratio";


// Parameters
  parameter Real m(unit ="tonnes")=5                    "Mass flow rate of the refigerant";   
  // From the R-134a tables, For p1=2.1912 bar at -10 degree celsius
  parameter Real p1(unit ="bar")=2.1912                 "Entropy";
  parameter Real h1(unit ="kJ/kg")=183.19               "Enthalpy";  
  parameter Real s1(unit ="kJ/kg*K")=0.7019             "Entropy";
  parameter Real v1(unit ="m^3/kg")=0.077               "Entropy";
  
  // For p2=9.6066 bar at 40 degree celsius
  parameter Real p2(unit ="bar")=9.6066                 "Entropy";
  parameter Real h3(unit ="kJ/kg")=74.59                "Enthalpy";
  
  parameter Real hf(unit ="kJ/kg")=26.87                "Enthalpy";
  parameter Real hfg(unit ="kJ/kg")=156.31              "Enthalpy";
  parameter Real T1(unit ="K")=313                      "Temperature";
  parameter Real T2(unit ="K")=263                      "Temperature";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
h4=h3;
s2=s1;
t2=48;      //by interpolation
h2=209.41;   //by interpolation
C=m*14000;
w=C/((h1-h4)*3600);
V=w*v1;
p=p2/p1;
Q2=w*(h2-h3);
x4=(h4-hf)/hfg;
COP=(h1-h4)/(h2-h1);
P=w*(h2-h1);
COP_rev=T2/(T1-T2);
E=COP/COP_rev;


end Ex14_3;
