model Ex14_6

extends Modelica.Math;
// Variables

Real COP_max(unit ="")                  "Maximum Coefficient of performance";
Real COP_actual(unit ="")               "Actual Coefficient of performance";
Real Qg(unit ="kW")                     "Heat transfer by generator";
Real Q(unit ="kJ/kg")                   "Heat transfer by 1kg of steam on condensation";
Real SFR(unit ="kg/s")                  "Steam flow rate";


// Parameters
  parameter Real Qe(unit ="tonnes")=20                    "Refrigeration load";   
  
  parameter Real T1(unit ="K")=393.2                      "Generator temperature";
  parameter Real T2(unit ="K")=303                        "Condenser and absorber temperature";  
  parameter Real Tr(unit ="K")=263                        "Evaporator temperature";
  
  parameter Real hfg(unit ="kJ/kg")=2201.9                "Enthalpy";
  parameter Real x(unit ="")=0.9                          "Dryness fraction";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

COP_max=((T1-T2)*Tr)/((T2-Tr)*T1);
COP_actual=COP_max*0.4;
Qg=Qe*14000/(COP_actual*3600);
Q=x*hfg;
SFR=Qg/Q;


end Ex14_6;
