model Ex14_7

extends Modelica.Math;
// Variables

Real T2s(unit ="K")                     "Temperature";
Real T2_1(unit ="K")                    "Temperature";
Real T2(unit ="K")                      "Temperature";
Real T4s(unit ="K")                     "Temperature";
Real T3_4(unit ="K")                    "Temperature";
Real T4(unit ="K")                      "Temperature";
Real COP(unit ="")                      "Coefficient of performance";
Real P(unit ="kW")                      "Driving power required";
Real m(unit ="kg/h")                    "Mass flow rate of air";


// Parameters
  parameter Real w(unit ="tonnes")=3                    "Refrigeration load";   
  
  parameter Real T1(unit ="K")=277                 "Compressor temperature";
  parameter Real T3(unit ="K")=328                 "Heat exchanger temperature";  
  parameter Real p1(unit ="MPa")=0.1               "Pressure";
  parameter Real p2(unit ="MPa")=0.3               "Pressure";
  parameter Real cp(unit ="kJ/kg*K")=1.005         "Specific heat constant pressure";
  parameter Real y(unit ="")=1.4                   "Specific heat ratio";
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation

T2s=T1*((p2/p1)^((y-1)/y));
T2_1=((T2s-T1)/0.72);                 //isentropic efficiency=72% //T2-T1
T2=T2_1+T1;
T4s=T3/((p2/p1)^((y-1)/y));
T3_4 = 0.78*(T3-T4s); 		       	// T3-T4  //isentropic efficiency=78%
T4 = T3-T3_4;
COP = (T1-T4)/((T2-T1)-(T3-T4));
P = (w*14000)/(COP*3600);
m = (w*14000)/(cp*(T1-T4));

//Answer may slightly vary due to rounding off error.
end Ex14_7;
