model Ex15_4

extends Modelica.Math;
// Variables
Real W3(unit ="kg vap/kg dry air")                            "Specific humidity";
Real G(unit ="kg dry air/sec")                                "Flow rate";
Real CC(unit ="tonnes")                                       "Cooling coil capacity";
Real CH(unit ="kW")                                           "Capacity of the heating coil";
Real R(unit ="kg/s")                                          "Rate of water vapour removed ";


// Parameters
  parameter Real h1(unit ="kJ/kg")=82                         "Enthalpy";   
  parameter Real h2(unit ="kJ/kg")=52                         "Enthalpy";
  parameter Real h3(unit ="kJ/kg")=47                         "Enthalpy";  
  parameter Real h4(unit ="kJ/kg")=40                         "Enthalpy";
  parameter Real W1(unit ="kg vap/kg dry air")=0.020          "Specific humidity";
  parameter Real W2(unit ="kg vap/kg dry air")=0.0115         "Specific humidity";
  parameter Real v1(unit ="m^3/kg dry air")=0.887             "Specific volume";
  parameter Real v(unit ="m^3/kg dry air")=3.33               "Specific volume";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
W3=W2;
G = v/v1;
CC = (G*(h1-h3)*3600)/14000; 	
CH = G*(h2-h3);		
R = G*(W1-W3);

end Ex15_4;
