model Ex15_9

extends Modelica.Math;
// Variables
Real Pw1(unit ="bar")                         "Pressure";
Real Pw2(unit ="bar")                         "Pressure";
Real W1(unit ="kg vap/kg dry air")            "Specific humidity";
Real W2(unit ="kg vap/kg dry air")            "Specific humidity";
Real MW(unit ="kg vap/kg dry air")            "Make-up water";
Real h4_3(unit ="kJ/kg")                      "Enthalpy";
Real h5(unit ="kJ/kg")                        "Enthalpy";
Real m_dot_w(unit ="kg water/kg dry air")     "Mass flow rate of water";
Real R(unit ="kg/s")                          "Rate of dry air flow";
Real MWR(unit ="kg/s")                        "Make-up water flow rate";
Real RWA(unit ="kg/s")                        "Rate of wet air flow";
Real V_dot(unit ="m^3/s")                     "Volume flow rate of air";


// Parameters
  parameter Real Psat1(unit ="bar")=0.01705             "Saturated pressure";   
  parameter Real hg1(unit ="kJ/kg")=2528.9              "Enthalpy";
  parameter Real Psat2(unit ="bar")=0.05628             "Saturated pressure";
  parameter Real hg2(unit ="kJ/kg")=2565.3              "Enthalpy";
  parameter Real fi1(unit ="")=0.55                     "Relative humidity";
  parameter Real fi2(unit ="")=1                        "Relative humidity";
  parameter Real P(unit ="bar")=1                       "Atmospheric pressure";
  parameter Real t2(unit ="degree celsius")=35          "Inlet temperature";
  parameter Real t1(unit ="degree celsius")=15          "Exit temperature";
  parameter Real m_dot(unit ="kg/s")=2.78               "Water flow rate";
  parameter Real cpa(unit ="kJ/kg*K")=1.005             "Specific heat at constant pressure";
  parameter Real Ra(unit ="kJ/kg*K")=0.287              "Gas constant";
  parameter Real T(unit ="K")=288                       "Temperature";
  
  
  final constant Real e = Modelica.Math.exp(1.0);
  
// Equations
equation
Pw1 = fi1*Psat1;
Pw2 = fi2*Psat2;
W1 = (0.622*Pw1)/(P-Pw1);
W2 = (0.622*Pw2)/(P-Pw2);
MW = W2-W1;
h4_3 = 35*4.187; 			// h4-h3
h5 = 14*4.187;
m_dot_w = (-(W2-W1)*h5 - W1*hg1 + W2*hg2 + cpa*(t2-t1))/(h4_3) ;
R = m_dot/m_dot_w ;
MWR = (W2-W1)*R;
RWA = R*(1+W1);
V_dot = (RWA*Ra*T)/(P*1e02) ; 			

end Ex15_9;
