model Ex18_3

extends Modelica.Math;
// Variable

Real P2(unit ="bar")                             "Pressure";
Real W(unit ="kJ/kg")                            "Work done";       
Real T2(unit ="K")                               "Temperature";
Real H(unit ="kJ/kg")                            "Heat rejected to the intercooler";


// Parameters

  parameter Real P1(unit ="bar")=1                   "Pressure";
  parameter Real P3(unit ="bar")=9                   "Pressure";
  parameter Real T1(unit ="K")=300                   "Temperature";
  parameter Real Cp(unit ="kJ/kg*K")=1.005           "Specific heat at constant pressure";
  parameter Real n(unit ="")=1.3                     "Polytropic index";
  parameter Real R(unit ="kJ/kg*K")=0.287            "Gas constant";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation
P2 = sqrt(P1*P3);
W = ((2*n*R*T1)/(n-1))*((P2/P1)^((n-1)/n)-1);
T2 = T1*(P2/P1)^((n-1)/n);
H = Cp*(T2-T1);


end Ex18_3;
