model Ex18_7

extends Modelica.Math;
// Variable

Real P2(unit ="bar")                             "Pressure";
Real Va(unit ="m^3/rev")                         "Volume of air";       
Real WD(unit ="kJ/rev")                          "Work done";
Real Pi(unit ="bar")                             "Pressure";
Real Aa(unit ="kJ/rev")                          "Area A";
Real Vb(unit ="m^3/rev")                         "Volume B";
Real Ab(unit ="kJ/rev")                          "Area B";
Real WR(unit ="kJ/rev")                          "Work required";

// Parameters

  parameter Real P1(unit ="bar")=1.013             "Pressure";   
  parameter Real Vs(unit ="m^3/rev")=0.03          "Swept volume";  
  parameter Real y(unit ="")=1.4                   "Index";
  
  final constant Real e = Modelica.Math.exp(1.0);
  final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
// Equations
equation

P2 = 1.5*P1;
Va = Vs;
WD = (P2-P1)*Vs*100;
Pi = (P1+P2)/2;
Aa = ((y*P1*100*Vs)/(y-1))*((Pi/P1)^((y-1)/y)-1);
Vb = Va *(P1/Pi)^(1/y);
Ab = Vb*(P2-Pi)*100;
WR = Aa+Ab;


end Ex18_7;
