model Ex3_10

extends Modelica.Math;

// Variables
Real n1(unit="")                         "Polytropic index";
Real n2(unit="")                         "Polytropic index";
Real W(unit="kJ")                        "Work done by the system";


// Parameters
 parameter Real P1(unit="kPa")=100        "Pressure";
 parameter Real P2(unit="kPa")=37.9       "Pressure";
 parameter Real P3(unit="kPa")=14.4       "Pressure";
 parameter Real V1(unit="m^3")=0.1        "Volume";
 parameter Real V2(unit="m^3")=0.2        "Volume";
 parameter Real V3(unit="m^3")=0.4        "Volume";
 

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

n1 = (log(P1/P2))/(log(V2/V1));
n2 = (log(P2/P3))/(log(V3/V2));
// n1 = n2
W = ((P1*V1)-(P3*V3))/(n1-1);

//Answer may vary due to rounding off error.

end Ex3_10;
