model Ex3_11

extends Modelica.Math;

// Variables
Real P1(unit="bar")                         "Pressure";
Real V2(unit="m^3")                         "Volume";
Real P2(unit="bar")                         "Pressure";
Real W12(unit="kJ")                         "Work done by the system";
Real W23(unit="kJ")                         "Work done by the system";
Real Wc(unit="kJ")                          "Work in the cycle";


// Parameters
 parameter Real p1(unit="atm")=20        "Pressure";
 parameter Real V1(unit="m^3")=0.04      "Volume";
 parameter Real n(unit="")=1.45          "Polytropic index";
 

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

P1 = p1*1.01325;
V2 = 2*V1;
P2 = (V1/V2)^n*P1;
W12 = ((P1*V1)-(P2*V2))*100/(n-1);
W23 = P2*(V2-V1)*100;
Wc = W12-W23;


// The  answer may slightly vary due to  rounding off values
end Ex3_11;
