model Ex3_6

extends Modelica.Math;

// Variables
Real H(unit="kJ/kg")                           "Heat required";
Real Mr(unit="kg/h")                           "Melting rate";
Real Hr(unit="kJ/h")                           "Rate of heat supply";
Real HrA(unit="kW")                            "Actual rate of heat supply";
Real V(unit="m^3")                             "Volume required";
Real d(unit="m")                               "Diameter of cylinder of furnace";
Real l(unit="m")                               "Length of cylinder of furnace";


// Parameters
  parameter Real Tm(unit="K")=1535              "Melting point of iron on degree";
 parameter Real Ti(unit="K")=15                 "Initial temperature";
 parameter Real Tf(unit="K")=1650               "Final temperature";
 parameter Real Lh(unit="J/kg")=270             "Latent heat of iron";
 parameter Real ml(unit="kJ/kg*K")=29.93        "Atomic weight of iron in liquid state";
 parameter Real m(unit="")=56                   "Atomic weight of iron";
 parameter Real Sh(unit="kJ/kg*K")=0.502        "Specific heat of iron in solid state";
 parameter Real rho(unit="kg/m^3")=6900         "Density of molten metal";
 parameter Real n(unit="")=0.7                  "Furnance efficiency";
 

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

H = (Tm-Ti)*Sh + Lh + (ml/m)*(Tf-Tm); 			    // Heat required
Mr = 5e03;      	    	                    	// Melting rate
Hr = H*Mr;      	    	    	                // Rate of heat supply
HrA = Hr/(n*3600);   		                     	// Actual rate of heat supply
V = (3*Mr)/rho;                   		        	// Volume required
d = ((V/2)*(4/pi))^(1/3); 			                // Diameter of cylinder of furnace
l = 2*d; 			                                // Length of cylinder of furnace

//Answer of HrA given in book is wrong. 
// Answer may vary due to rounding off error.


end Ex3_6;
