model Ex3_9

extends Modelica.Math;

// Variables
Real t(unit="s")                         "Time";
Real Wm(unit="J")                        "Work input to the motor";
Real Ws(unit="J")                        "Work input to the stirrer";
Real W(unit="J")                         "Work done by the fluid on the atmosphere";


// Parameters
 parameter Real dc(unit="m")=40e-02         "Diameter of cylinder";
 parameter Real L(unit="m")=30e-02          "Piston displacement";
 parameter Real P(unit="pa")=1e05           "Pressure";
 parameter Real I(unit="amp")=0.5           "Current supplied to motor";
 parameter Real V(unit="V")=24              "Voltage";
 

 final constant Real e = Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
  
 
// Equations
equation

t = 15.*60; 			
Wm = V*I*t;                //Work input to the motor
Ws = 0.9*Wm;               //Work input to the stirrer
W = P*(pi/4)*dc^2*L;       //Work done by the fluid on the atmosphere


end Ex3_9;
