model Ex4_3


// Variables
Real Qd_a(unit="kJ/min")                  "Heat transfer rate in the process d-a";
Real Wc_d(unit="kJ/min")                  "Work output rate in the process c-d";
Real Wd_a(unit="kJ/min")                  "Work output rate in the process d-a";
Real Ea_b(unit="kJ/min")                  "Rate of energy transfer in the process a-b";
Real Eb_c(unit="kJ/min")                  "Rate of energy transfer in the process b-c";
Real Ed_a(unit="kJ/min")                  "Rate of energy transfer in the process d-a";
   

// Parameters
 parameter Real Q_cycle(unit="kJ/min")=-17000          "Sum of all Heat transfer rate";
 //system completes 100 cycles/min so that Q_cycle=170KJ*100cycle/min 
 parameter Real Qa_b(unit="kJ/min")=0                "Heat transfer rate in the process a-b";
 parameter Real Qb_c(unit="kJ/min")=21000            "Heat transfer rate in the process b-c";
 parameter Real Qc_d(unit="kJ/min")=-2100            "Heat transfer rate in the process c-d";
 parameter Real Wa_b(unit="kJ/min")=2170             "Work output rate in the process a-b";
 parameter Real Wb_c(unit="kJ/min")=0                "Work output rate in the process b-c";
 parameter Real Ec_d(unit="kJ/min")=-36600           "Energy transfer rate in the process c-d";
 
// Equations
equation

Ea_b=Qa_b-Wa_b;                    //Rate of energy transfer in the process a-b
Eb_c=Qb_c-Wb_c;                    //Rate of energy transfer in the process b-c
Wc_d=Qc_d-Ec_d;                    //Work output rate in the process b-c  
Qd_a=Q_cycle-Qa_b-Qb_c-Qc_d;       //Heat transfer rate in the process d-a
Ed_a=-Ea_b-Eb_c-Ec_d;              //Rate of energy transfer in the process d-a 
//since cyclic integral of any property is zero.  
Wd_a=Qd_a-Ed_a;                    //Work output rate in the process d-a

end Ex4_3;
