package Ex4_4


model Ex4_4_a

Real delta_U(unit="kJ")                            "Change in internal energy";
Real V2(unit="m^3")                                "Final volume";
Real W(unit="kJ")                                  "Work done"; //for a quasi-static process
Real Q(unit="kJ")                                  "Heat transfer";

 parameter Real P1(unit="kPa")=500                 "Initial pressure";
 parameter Real P2(unit="kPa")=100                 "Final pressure";
 parameter Real V1(unit="m^3")=0.22                "Initial volume";
 parameter Real n(unit="")=1.2                     "Polytropic index";
 
equation

delta_U=3.56*(P2*V2-P1*V1);         //Change in internal energy
//equation given in question...u=3.56*p*v+84
V2=V1*((P1/P2)^(1/1.2));            //Final volume // process p*v^1.2=constant
W=(P2*V2-P1*V1)/(1-n);              //Work done
Q=delta_U+W;                        //Heat transfer


//The  answer may slightly vary due to  rounding off values
end Ex4_4_a;

//=========================================================================================

model Ex4_4_b

Real W(unit="kJ")                                     "Change in internal energy";

 parameter Real Q(unit="kJ")=30                       "Heat transfer";
 parameter Real delta_U(unit="kJ")=-91                "Change in internal energy"; 
 //Since end states are same,delta_U would remain same as part a.
 
equation

W=Q-delta_U;            //Change in internal energy



//(c):The work in part (b) is not equal to p*dv, since the process is not quasi-static.

end Ex4_4_b;
//============================================================================================

//example (c)
// The work in (b) is not equal to integral of p*dV,since the process is not quasi-static.

end Ex4_4;
