model Ex4_5

// Variables
Real delta_U(unit="kJ")          "Change in the internal energy of the fliud during the process";
Real W(unit="kJ")                "Work transfer involved during the process";
Real Q(unit="kJ")                "Heat transfer";
  

// Parameters
 parameter Real V1(unit="m^3")=0.03           "Initial Volume";
 parameter Real V2(unit="m^3")=0.06           "Final Volume";
 parameter Real p1(unit="kPa")=1.7            "Initial pressure";
 parameter Real p2(unit="kPa")=4              "Final pressure";
 parameter Real a(unit="")=-60                "Constant";
 parameter Real b(unit="")=7667               "Constant";
 
// Equations
equation

delta_U=3.15*100*(p2*V2-p1*V1); //Change in the internal energy of the fliud during the process= U2-U1
W=(V2-V1)*(a+b*(V1+V2)/2);      //Work transfer involved during the process
Q=delta_U+W;                    //Heat transfer 


end Ex4_5;
