model Ex5_2

extends Modelica.Math;
// Variables

Real delta_u(unit="kJ")                       "Specific internal energy";


// Parameters
 
 parameter Real p2(unit="kPa")=100                   "Final pressure";
 parameter Real p1(unit="kPa")=600                   "Initial pressure";
 parameter Real v2(unit="m^3/kg")=0.62               "Final Specific volume"; 
 parameter Real v1(unit="m^3/kg")=0.37               "Initial specific volume" ; 
 parameter Real V2(unit="m/s")=270                   "Final velocity" ;
 parameter Real V1(unit="m/s")=16                    "Initial velocity" ;
 parameter Real Z2(unit="m")=0                       "Final height" ;
 parameter Real Z1(unit="m")=32                      "Initial height" ;
 parameter Real dQ(unit="kJ/kg")=-9                  "Rate of heat absorbed from the air" ;
 parameter Real dW(unit="kJ/kg")=135                 "Work done by fluid" ;
 parameter Real g(unit="m/s^2")=9.8                  "Gravitational acceleration" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation
//Steady flow energy equation
delta_u=(p2*v2-p1*v1)+(V2^2-V1^2)*1e-03/2+((Z2-Z1)*g*1e-03)+dW-dQ;              //U1-U2

//Note : The  answer may slightly vary due to  rounding off values.
end Ex5_2;
