model Ex5_5


extends Modelica.Math;
// Variables

Real Q(unit="kJ/s")                       "Rate of heat transfer to the air in the heat exchanger";
Real Wt(unit="kW")                       "Power output from the turbine";
Real V4(unit="m/s")                       "Velocity at exit from the nozzle";


// Parameters
 
 parameter Real w(unit="kg/s")=2                  "Air flow rate";
 parameter Real T1(unit="degree celcius")=15      "Initial temperature in Heat exchanger ";
 parameter Real T2(unit="degree celcius")=800     "Temperature increases in Heat exchanger "; 
 parameter Real T3(unit="degree celcius")=650     "Temperature falls in turbine" ;
 parameter Real T4(unit="degree celcius")=500     "Temperature falls in nozzle" ; 
 parameter Real V1(unit="m/s")=30                 "Velocity" ;
 parameter Real V2(unit="m/s")=30                 "Velocity" ;
 parameter Real V3(unit="m/s")=60                 "Velocity" ;
 parameter Real Cp(unit="kJ/kg*K")=1.005          "Specific heat at constant pressure" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

Q=w*Cp*(T2-T1);
//Energy equation for the turbine
Wt=w*((V2^2-V3^2)*1e-03/2+(T2-T3));
//Energy equation for the nozzle
V4=sqrt(w*Cp*(T3-T4)*1e03+V3^2);


// The  answer may slightly vary due to  rounding off values.
end Ex5_5;
