model Ex5_7

extends Modelica.Math;
// Variables

Real Eg(unit="kW")                     "Power input of the turbine";
Real Vg(unit="m/s")                    "Velocity of exhaust gas";

// Parameters
 
 
 parameter Real wa(unit="kg/s")=1                   "Mass flow rate"; 
 parameter Real wg(unit="")=1.0190                  "Fuel to air ratio wf/wa";
 parameter Real Va(unit="m/s")=270                  "Velocity of air";
 parameter Real ha(unit="kJ/kg")=260                "Enthalpy of air";
 parameter Real hg(unit="kJ/kg")=912                "Enthalpy of gas"; 
 parameter Real wf(unit="")=0.0190                  "Fuel to air ratio wf/wa" ;
 parameter Real Ef(unit="kJ/kg")=44.5e03            "Chemical energy of fuel" ;
 parameter Real Q(unit="kJ/kg")=-21                 "Heat loss from the engine" ;
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 // Equations

equation
Eg=0.05*wf*Ef/wg;              // As 5% of chemical energy is not released in reaction
//Steady flow energy equation
Vg=sqrt((2000/wg)*((wa*ha-wg*hg)+(wa*Va^2*1e-03/2)+(wf*Ef)+Q-(Eg*wg)));


//The  answer provided in the textbook is wrong.

end Ex5_7;
