model Ex7_1

extends Modelica.Math;
// Variables
Real delta_S(unit="kJ/K")                                   "Change in entropy";



// Parameters
 parameter Real T1(unit="K")=308                 "Initial temperature of turbine"; 
 parameter Real T2(unit="K")=310                 "Final temperature of turbine"; 
 parameter Real Cv(unit="KJ/Kg*K")=4.187         "Specific heat at constant volume";   
 parameter Real m(unit="Kg")=1                   "Mass";
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 

delta_S=m*Cv*log(T2/T1);


//The  answer may slightly vary due to  rounding off values.

end Ex7_1;
