model Ex7_11

// Variables

Real delta_S_sys(unit="kJ/kg*K")                   "Change in entropy of system";
Real delta_S_surr(unit="kJ/kg*K")                  "Change in entropy of surroundings";
Real delta_S_uni(unit="kJ/kg*K")                   "Change in entropy of universe";

// Parameters
 parameter Real Pa(unit="kPa")=130                 "Pressure at point A"; 
 parameter Real Pb(unit="kPa")=100                 "Pressure at point B"; 
 parameter Real Ta(unit="K")=323                   "Temperature at point A";   
 parameter Real Tb(unit="K")=286                   "Temperature at point B";
 parameter Real Cp(unit="kJ/kg*K")=1.005           "Specific heat at constant pressure"; 
 
 // Equations
equation 

delta_S_sys=(Cp*log(Tb/Ta))-(0.287*log(Pb/Pa));
delta_S_surr=0;  //since the duct is insulated
delta_S_uni=delta_S_sys+delta_S_surr;

//The  answer may slightly vary due to  rounding off values.
end Ex7_11;
