model Ex7_13

// Variables

Real Q(unit="W")                                   "Rate of heat transfer through the wall";
Real delta_S_wall(unit="W/K")                      "Entropy generation through the wall";
Real delta_S_total(unit="W/K")                     "Total entropy genertaion";

// Parameters
 parameter Real T1(unit="K")=300                   "Room temperature"; 
 parameter Real T_surr(unit="K")=275               "Surrounding temperature"; 
 parameter Real Ta(unit="K")=294                   "Temperature of inner surface of the wall";   
 parameter Real Tb(unit="K")=279                   "Temperature of outer surface of the wall";
 parameter Real L(unit="m")=0.32                   "Thickness of wall"; 
 parameter Real A(unit="m^2")=35                   "Cross-sectional area of wall"; 
 parameter Real K(unit="W/m*K")=0.71               "Thermal conductivity";   
 
 // Equations
equation 
Q=(K*A*(Ta-Tb))/L;
delta_S_wall=(Q/Tb)-(Q/Ta);
delta_S_total=(Q/T_surr)-(Q/T1);

end Ex7_13;
