package Ex7_2

model Ex7_2_a
extends Modelica.Math;
// Variables
Real delta_S_water(unit="kJ/K")           "Entropy change of water";
Real delta_S_res(unit="kJ/K")             "Entropy change of the reservoir";
Real delta_S_univ(unit="kJ/K")            "Entropy change of the universe";
Real Q(unit="kJ")                         "Amount of heat absorbed by the system from the reservoir";

// Parameters
 parameter Real T1(unit="K")=273              "Initial temperature"; 
 parameter Real T2(unit="K")=373              "Final temperature"; 
 parameter Real C(unit="KJ/Kg*K")=4.187       "Specific heat at constant volume";   
 parameter Real m(unit="Kg")=1                "Mass of water";
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 
delta_S_water=m*C*log(T2/T1);
Q=m*C*(T2-T1);
delta_S_res=-Q/T2;
delta_S_univ=delta_S_water+delta_S_res;


end Ex7_2_a;
//===================================================================================================

model Ex7_2_b
extends Modelica.Math;

// Variables
Real delta_S_water(unit="kJ/K")                  "Entropy change of water";
Real delta_S_res1(unit="kJ/K")                   "Entropy change of the reservoir 1";
Real delta_S_res2(unit="kJ/K")                   "Entropy change of the reservoir 2";
Real delta_S_univ(unit="kJ/K")                   "Entropy change of the universe";


// Parameters

//water is being heated in two stages, first from 273K to 323K by bringing it in contact with reservoir at 323K, and then from 323K to 373K by bringing it in contact of a second reservoir at 373K.
 parameter Real T0(unit="K")=323                "Reservoir temperature" ; 
 parameter Real T1(unit="K")=273                "Initial temperature"; 
 parameter Real T2(unit="K")=373                "Final temperature"; 
 parameter Real C(unit="KJ/Kg*K")=4.187         "Specific heat at constant volume";   
 parameter Real m(unit="Kg")=1                  "Mass of water";
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation 
delta_S_water=m*C*(log(T0/T1)+log(T2/T0));
delta_S_res1=-m*C*(T0-T1)/T0;
delta_S_res2=-m*C*(T2-T0)/T2;
delta_S_univ=delta_S_water+delta_S_res1+delta_S_res2;

end Ex7_2_b;


end Ex7_2;
