model Ex8_10

// Variables

Real delta_p(unit="bar")                     "Pressure drop";
Real S_gen(unit="kW/K")                      "Rate of energy generation"; 
Real I(unit="kW")                            "Rate of energy loss"; 

// Parameters
 
 parameter Real m(unit="kg/s")=3               "Mass flow rate"; 
 parameter Real R(unit="kJ/kg*K")=0.287        "Gas constant";  
 parameter Real p1(unit="K")=1                 "Pressure"; 
 parameter Real T0(unit="K")=300               "Atmospheric temperature" ; 
 
 // Equations
equation
delta_p=0.1*p1;
S_gen=m*R*delta_p/p1;
I=T0*S_gen;

end Ex8_10;
