model Ex8_11
extends Modelica.Math;
// Variables

Real m(unit="kg/s")                     "Total mass";
Real x(unit="")                         "Mass ratio"; 
Real T(unit="")                         "Temperature ratio"; 
Real S_gen(unit="kW/K")                 "Entropy generation";
Real I(unit="kW")                       "Rate of exergy loss due to mixing";
Real delta_S_univ(unit="kW/K")          "Change in entropy of universe";
Real t(unit="kW")                       "Equlibrium temperature after mixing";

// Parameters
 
 parameter Real m1(unit="kg/s")=2               "Mass flow rate"; 
 parameter Real m2(unit="kg/s")=1               "Mass flow rate";
 parameter Real Cp(unit="kJ/kg*K")=4.187        "Specific heat at constant pressure";  
 parameter Real T0(unit="K")=300                "Atmospheric temperature" ; 
 parameter Real T1(unit="K")=363                "Temperature";
 parameter Real T2(unit="K")=303                "Temperature";
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations
equation

m=m1+m2;
x=m1/m;
T=T2/T1;
S_gen=m*Cp*log((x+T*(1-x))/T^(1-x));
I=T0*S_gen;
t=(m1*T1+m2*T2)/(m1+m2);
delta_S_univ=m1*Cp*log(t/T1)+m2*Cp*log(t/T2);


end Ex8_11;
