
model Ex8_14

extends Modelica.Math;
// Variables

Real W(unit="KW")                       "Power input";
Real delta_a(unit="kJ/kg")              "Change in acceleration";
Real n2(unit="%")                       "Second law efficiency";

// Parameters
 
 parameter Real m(unit="kg/s")=1                     "Rate of flow of products"; 
 parameter Real Q(unit="KW")=-100                    "Rate of flow of air"; 
 parameter Real Cp(unit="kJ/kg*K")=1.005             "Speific heat at constant prssure"; 
 parameter Real R(unit="kJ/kg*K")=0.287              "Gas constant"; 
 parameter Real T0(unit="K")=298                     "Surounding temperature"; 
 parameter Real T1(unit="K")=298                     "Initial temperature of air" ; 
 parameter Real T2(unit="K")=433                     "Final temperature of air" ;
 parameter Real p1(unit="bar")=1                     "Initial pressure of air" ;
 parameter Real p2(unit="bar")=8                     "Final pressure of air";
 parameter Real h1(unit="")=25                       "Enthlapy of air" ;
 parameter Real h2(unit="")=160                      "Enthlapy of air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation
//SFEE for compressor
W=Q+m*(h1-h2);
delta_a=Cp*(T2-T1)-T0*((Cp*log(T2/T1))-(R*log(p2/p1)));
n2=-m*delta_a*100/W;

end Ex8_14;
