model Ex8_16

extends Modelica.Math;
// Variables


Real delta_H(unit="kJ")               "Change in enthalpy";
Real delta_S(unit="kJ/K")             "Change in entropy";
Real E(unit="kJ")                     "Exergy produced";

// Parameters
 
 parameter Real m(unit="kg/s")=1000            "Mass flow rate"; 
 parameter Real L(unit="kJ/kg")=235            "Latent heat of fusion for the fish"; 
 parameter Real Cp1(unit="kJ/kg*K")=1.7        "Speific heat of product at constant pressure"; 
 parameter Real Cp2(unit="kJ/kg*K")=3.2        "Speific heat of air at constant pressure"; 
 parameter Real T1(unit="K")=253               "Required cooling temperature" ; 
 parameter Real T2(unit="K")=270.8             "Freezing point of fish" ;
 parameter Real T0(unit="K")=300               "Surrounding temperature of air" ;
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

delta_H=m*(Cp1*(T2-T1)+L+Cp2*(T0-T2));
delta_S=m*((Cp1*log(T2/T1))+(L/T2)+(Cp2*log(T0/T2)));
E=-(delta_H-(T0*delta_S));

end Ex8_16;
