package Ex8_19

model Ex8_19_a

extends Modelica.Math;
// Variables


Real I1(unit="kW")                           "Rate of Irreversibility";
Real I2(unit="kW")                           "Rate of availability transfer with heat";

// Parameters
 
 parameter Real W(unit="kW")=8.5                   "work done"; 
 parameter Real T(unit="K")=1500                   "Furnace temperature" ;
 parameter Real T0(unit="K")=300                   "Surrounding temperature of air" ;
 parameter Real Q(unit="kW")=-8.5                  "Heat transfer" ; 
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

I1=(1-(T0/T))*Q+W;
I2=(1-(T0/T))*Q;


end Ex8_19_a;

//===============================================================================================


model Ex8_19_b

extends Modelica.Math;
// Variables


Real I1(unit="kW")                           "Rate of Irreversibility";

// Parameters
 
 parameter Real W(unit="kW")=0                "work done"; //steady state
 parameter Real T1(unit="K")=1500             "Furnace temperature" ;
 parameter Real T2(unit="K")=500              "Furnace wall temperature" ;
 parameter Real T0(unit="K")=300              "Surrounding temperature of air" ;
 parameter Real Q(unit="kW")=8.5              "Heat transfer" ; 
 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

I1=(1-(T0/T1))*Q-(1-(T0/T2))*Q-W;

end Ex8_19_b;


//===============================================================================================
end Ex8_19;
