model Ex8_5

extends Modelica.Math;
// Variables

Real w1(unit="rad/s")                       "Initial angular velocity of the flywheel";
Real AE_initial(unit="kJ")                  "Initial Available energy of the flywheel  ";
Real delta_t(unit="degree celsius")         "Temperature rise of the bearing";
Real Tf(unit="K")                           "Final temperature of the bearing";
Real T1(unit="K")                           "Final temperature of the bearing";
Real AE(unit="kJ")                         "Returnable available energy as high grade energy";
Real UAE(unit="kJ")                        "Amount of energy rendered unavailable";
Real w2(unit="rad/s")                       "Final angular velocity of the flywheel";
Real N2(unit="rpm")                       "Final RPM of the flywheel";

// Parameters
 parameter Real N1(unit="rpm")=3000                 "Initial RPM of the flywheel";  
 parameter Real I(unit="kg*m^2")=0.54               "Moment of inertia of a flywheel"; 
 parameter Real m(unit="kg")=2                      "Mass of water";  
 parameter Real Cp(unit="kJ/kg*K")=4.187           "Speific heat of water at constant pressure"; 
 parameter Real T(unit="degree celsius")=15        "Surounding temperature"; 

 final constant Real e=Modelica.Math.exp(1.0);
 final constant Real pi=2*Modelica.Math.asin(1.0); // 3.14159265358979;
 
 // Equations
equation

w1=(2*pi*N1)/60;
AE_initial=(I*w1^2)/2e03;
delta_t=AE_initial/(m*Cp);
Tf=T+delta_t+273;
T1=T+273;
AE=m*Cp*((Tf-T1)-T1*log(Tf/T1));
UAE=AE_initial-AE;
w2=sqrt((AE*1e03*2)/I);
N2=(w2*60)/(2*pi);

end Ex8_5;
