model Ex8_7

extends Modelica.Math;
// Variables

Real W_max(unit="kJ/kg")                       "Maximum work";
Real AE(unit="kJ/kg")                          "Change in availability";
Real W(unit="kJ/kg")                           "Maximum work";                 //from S.F.E.E
Real I(unit="kJ/kg")                           "Irreversibility";

// Parameters
 
 parameter Real R(unit="kJ/kg*K")=0.287            "Gas constant";  
 parameter Real Cp(unit="kJ/kg*K")=1.005           "Speific heat at constant pressure"; 
 parameter Real T0(unit="K")=293                   "Surounding temperature"; 
 parameter Real T1(unit="K")=793                    "Air temperature" ; 
 parameter Real T2(unit="K")=573                    "Air temperature" ;
 parameter Real Q(unit="kJ/kg")=-10                 "Heat loss to the surroundings";
 parameter Real P1(unit="kPa")=500                        "Initial pressure"      ; 
 parameter Real P2(unit="kPa")=100                        "Final pressure" ; 
 
 final constant Real e=Modelica.Math.exp(1.0);
 
 // Equations

equation

AE=Cp*(T1-T2)-T0*(R*log(P2/P1)-Cp*log(T2/T1));
W_max=AE;
W=Cp*(T1-T2)+Q;
I=W_max-W;


end Ex8_7;
